/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class WoodworkingRecipe
extends SingleItemRecipe {
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final ResourceLocation id;
    protected final String group;

    public WoodworkingRecipe(ResourceLocation pId, String pGroup, Ingredient pIngredient, ItemStack pResult) {
        super((RecipeType)RecipeTypeRegistry.WOODWORKING.get(), (RecipeSerializer)RecipeSerializerRegistry.WOODWORKING_SERIALIZER.get(), pId, pGroup, pIngredient, pResult);
        this.id = pId;
        this.group = pGroup;
        this.ingredient = pIngredient;
        this.result = pResult;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.ingredient.test(pContainer.m_8020_(0));
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@NotNull RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.WOODWORKING.get();
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerRegistry.WOODWORKING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<WoodworkingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("ultramarine", "woodworking");

        protected Serializer() {
        }

        @NotNull
        public WoodworkingRecipe fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pJson) {
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"));
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)pJson, (String)"count");
            ItemStack itemstack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s1)), i);
            return new WoodworkingRecipe(pRecipeId, s, ingredient, itemstack);
        }

        public WoodworkingRecipe fromNetwork(@NotNull ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            ItemStack itemstack = pBuffer.m_130267_();
            return new WoodworkingRecipe(pRecipeId, s, ingredient, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, WoodworkingRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.group);
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

